

new Vue({
  el: '#bobcat', // corresponds to <div id="bobcat"> in catshow.html

  data: {
    // Which breed to start with (American Bobtail). Change to 'abys', 'manx', etc.
    whichcat: 'abob',

    // Current image object { url, id, width, height }
    image: { url: '' },

    // A few metadata fields students can later render in the HTML
    breedName: '',
    breedDescription: '',
    breedTemperament: '',
    breedOrigin: '',

    // The full array of images returned by the search endpoint
    allofit: [],
    i: 0 // index pointer for the slideshow
  },

  // (15) On creation, call loadNextImage with this.whichcat
  created() {
    this.loadNextImage(this.whichcat);
  },

  methods: {
    // Fetch a batch of images for the given breed, then fetch extra breed data
    async loadNextImage(breedID) {
      try {
        // Replace with your own Cat API key: https://thecatapi.com/
        axios.defaults.headers.common['x-api-key'] = 'YOUR_API_KEY_HERE';

        // Request multiple images for the breed
        const response = await axios.get(
          'https://api.thecatapi.com/v1/images/search?breed_ids=' + breedID,
          { params: { limit: 10, size: 'full' } }
        );

        // Grab the first image id so we can request detailed breed info
        const theid = response.data[0].id;
        const response2 = await axios.get('https://api.thecatapi.com/v1/images/' + theid);

        // Save some breed metadata (students will display these later)
        const b = response2.data.breeds && response2.data.breeds[0];
        this.breedName = b ? b.name : '';
        this.breedDescription = b ? b.description : '';
        this.breedTemperament = b ? b.temperament : '';
        this.breedOrigin = b ? b.origin : '';

        // (31) Store the whole images array for the slideshow
        this.allofit = response.data;

        // Kick off the first image
        this.slideshow();
      } catch (err) {
        console.log(err);
      }
    },

    // (37) Advance to the next image; wrap to 0 at the end
    slideshow() {
      if (!this.allofit || this.allofit.length === 0) return;
      if (this.i >= this.allofit.length) {
        this.i = 0;
      }
      this.image = this.allofit[this.i];
      this.i++;
    }
  }
});